//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Head Hunter
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
//
// This script handles non vanilla heads, and the beheading cyclic enchantment in a more correct way, also adds more heads and variations of them
// for decoration purposes.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Should heads drop? Setting to false will make beheading useless for non normal skulls
const allowHeadsToDrop = true;

// The formula to calculate the percentage of drop for the heads, the formula is a copy of the cyclic one using the values in
// the current config
const beheadingFormula = (level) => 20 + (level - 1) * 25;

// Heads to drop when mobs are killed with the Beheading enchantment
// - Key is mob type, value is the NBT
// - For variant mobs, the value is an object
//   - 'check' field is the function to grab the variant Info
//   - All other fields are the variant itself as key and value is the NBT
const headsToDrop = {
	"minecraft:blaze": `SkullOwner:{Id:[I;2095810738,2136949657,-1413910424,622570141],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjc4ZWYyZTRjZjJjNDFhMmQxNGJmZGU5Y2FmZjEwMjE5ZjViMWJmNWIzNWE0OWViNTFjNjQ2Nzg4MmNiNWYwIn19fQ=="}]}}}`, 
	"minecraft:cat": `{SkullOwner:{Id:[I;1166337133,-1400289858,-1548916893,-499049299],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTA1MDUzN2JhMjU1NzgxMTQxNWVmZTk2NzY4NTMyNTcyNTBiZGQyNDA3ZjczNzYxOTgyYWJmOWEwY2RjODgxNyJ9fX0="}]}}}`, 
	"minecraft:cave_spider": `{SkullOwner:{Id:[I;-894269583,-254980121,-1322712378,-1631946331],Name:"MHF_CaveSpider",Properties:{textures:[{Signature:"rPI0Hr4Wa6tj7lzG0o/y1Tubdu1IGBNuhER8ohZBAC8MRfKkHxJmZPELNEWceKcn/0pANiYwvH7TV2fEP/FrIWwDIokMoNiG77PvAIc9DcVGaHFhY6Mz95+C6quPczX0vFOxUt5Ejv/DdHItRmwkmA6HKp7DDPh2kML5fsVKAH2jfdj3aIsHjS2EvjnnKWHm/VaDBQLGIVyEkvq8IN/UhjfiUN8hrZ45L6h13XSef0uLz6vsywvYkrTVQLibljgyoJkb3+m++gBUclzmSWPTFqivED1e8/4zZzaXsBjod86G1IvEBII3rVjhe8UFoVHZnteKAk05f/G3iYmrIHjpuK4qMe5UM4wKGk8suqIsWJdNiSeIIjOCghnR3qxj/voXNVxklxQP+2hgf8mQ3SczFNA9lx6lQo3E+TCzPaNM+Q5jhTpPAbxN2JeZM8tmcqVe7DG9dXmi+0oU5c3dwpB2yI/kbFe5uNqZ6E+l/JFfC4TrRyAljDWIBgrob/ZqrTmeI9S9qM6UlfLWd2/k1zcQTfg33svzfxuldTopLjMsIKTaeQJARwm5g5In2iaost6ta0BeIYHdDDIn0T9du8TeXMz+tX9hlEixEw/nKjQ6xaA2Qa4xOGvDZE7Od7xirRUg9u/jcYUMBM+l32i0JvqO/cbIe6tguDg73kw6m6oypj0=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzNiwKICAicHJvZmlsZUlkIiA6ICJjYWIyODc3MWYwY2Q0ZmU3YjEyOTAyYzY5ZWJhNzlhNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfQ2F2ZVNwaWRlciIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS83N2IwNzA2M2E2ODc0ZmEzZTIyNTQ4ZTAyMDYyYmQ3MzNjMjU4ODU5Mjk4MDk2MjQxODBhZWJiODUxNTU3ZjZhIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:chicken": `{SkullOwner:{Id:[I;-1830899799,1124549337,-1341945760,362337984],Name:"MHF_Chicken",Properties:{textures:[{Signature:"lVMKI8j25bvFlj7U71KhEqOJk0b3WASr9CacwiZxIB/9RU+WJxjvg16A9X7b24phKFXmz3HI5rfupCXg3uW5lKSz3/qiQURX/HQ3ohUVn4tSMOGIKKTo5J/QVP0Ci9k7Hw5QYzVynNio0ZuPykWpTqxr2Y46tHC41sEkYR5Jl4l2Xi+ykxPglWcU1cMByj2uIZn60AYdDNRQLN5KJR/dtJBxVcMiZr5uCnO36GNx0lnqGEgF4dEyHxrNyfUuLN/cUW/YhpiQc0eeAY6ga9l3CnLVRud32iyjvemAZ8zfeUd+z6sksZLkO8KUBWOCNfvDxS5vh0QcveHdwPjly1YJDafU80qWcoaq9TkWSnlqQrE7HUhfg4XN1o5DPH9ZLCFBcN0JGGDunWKn+rPSTL8RC3Fm+RNsy0gBli+AKtT3NCKISyiXNZ7UpI/ZacmteXPKU8j6Kc43X9ifGJGYqk68Nk+RLNBUEIa3Z9R07G905x1nGxGsCx6/B3/d+ec94+2ounAyEYwXCwS4p1WtGymZBMWHXFgFoMymdQMfrZinBUupmigp+eFJkaM9mlA8rU4Zh6aK4LmN8GMks8ha6pwWGObhCUllJRk5mxr7NQWb/KDSVnNgxuMady7O+B9pAiW9lIBYY1mKt6gtz7NpqhT3JNt/jDjgDJgm/e4Gl/sd/Eg=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0OCwKICAicHJvZmlsZUlkIiA6ICI5MmRlYWZhOTQzMDc0MmQ5YjAwMzg4NjAxNTk4ZDZjMCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfQ2hpY2tlbiIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS85MTZiOGU5ODM4OWM1NDFiYjM2NDUzODUwYmNiZDFmN2JjNWE1N2RhNjJkY2M1MDUwNjA0MDk3MzdlYzViNzJhIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:cow": `{SkullOwner:{Id:[I;-245779852,-1037155520,-1212067157,-569084141],Name:"MHF_Cow",Properties:{textures:[{Signature:"wcvAlCELyaEpNuydnbVPdlbrrlgPAmN3Eal46v0bf2mT9Y8hZOwqzjISiXIYfe0MLtPZh3Qydqz10EFYXdTRvlb/i3IlWJX25XZFU/HbPQu3BhHy9xV/O/5MxKO9/CzaARYBwuTJnrecCa3th5KOWRgbu6eivZ6yK7k9aAhpO6dKXdW8QINdq8PYKMGXgsYU6mfxGJrJIt7PBA6a3qjiCoxu/briXKWEmX4lR06yUy+dnVQpg+y5skdKgdt6vScPzGUMucjAfsYOyD3lBBOBWCX6Ed9kCRMYF4MK80UbFyj77aaMDTglqzMhyI7vA4zXKKAPJx8KbwvG2itwQO6tfsjaG/uDYdjTV6LCuAllCk+1PE9KOIqhIc/PqEm9cgkjKbRwR/CbaNv04GhKKShxKwdm4zw9S4xlHTCE9kymWOjfLLHGg/1M4/mDgpxMshMsCKcG5VjJDgymIWpvZ10B1hzdb68tX8AEPf4xXyAgraJMCRytZ1qmpgNbLqTCFQLemhEqvKxPeWCJYQBLmN5Fov4KVZK+KQsLaW7l94h9cUlEBGcjEIaW4ndU1q2J3U4Vzy+KwHOBEhMI7v9VEk6yIHzFUr0KtykRkLIi0F5HUzs8qx6m6G4Zfg5t8KK0oMFUFBg7223NWsem8Z6PB0lnSLlZTyAWrVjohbG8ldIInsI=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk3MywKICAicHJvZmlsZUlkIiA6ICJmMTU5YjI3NGMyMmU0MzQwYjdjMTUyYWJkZTE0NzcxMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfQ293IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2QwZTRlNmZiZjVmM2RjZjk0NDIyYTFmMzE5NDQ4ZjE1MjM2OWQxNzlkYmZiY2RmMDBlNWJmZTg0OTVmYTk3NyIKICAgIH0KICB9Cn0="}]}}}`, 
	"minecraft:enderman": `{SkullOwner:{Id:[I;1090499442,318129784,-1275977354,-1084826293],Name:"MHF_Enderman",Properties:{textures:[{Signature:"Os7SZJ4NjwYLjYcKU0POebDFBCftY5HeyrlwjlvNn9a9SGf2Vl2DfYz5fn4nlodUgerO+9dR3A3SRxyNjOcWa6jfqxYAQy5oHo/zhVQGnCvrzPMcWoT3euyQ2z93Poo1L6QM/4PfsxpunnNq0Lg6AgyNoDzOdtggdmlriHfNJvSl4yK5GM1WCRivlRehew2W0ddMXfalO7JAcpJ1BjkTsRFmPqcttkEqiw6C7g0f4z+7I0WfRlUrGlzEYtRJq4IIRJl5fLrr7W0PQ39D5hIsvGvBRkSGbpG1joY+R/PWXXvZulKHReWtAKDVR9MEWgdZEERD4aYJd1lmUT04TaPy3QRfMixJBmOIKSJF8tHInIi388d6yx+fmIPNrbMshBMHgP4LedSZDFUdR2o/3vGAmlST4cz9UnsFuUvrykVQLOHS7jPC3L1YI/wWzg8TvZwM/LYTkrQcYBx5MgNR1i6BuVZbhPcFka43PkusgwWmnv0bwwdKL1q8VYSHJJfaTzDV5WHEqaQSONUuhI1D5l4b/b+d/MnGmpOq6L0smjiMbj9ivp1ykTFACGQzbJQA3Pmo5G0RuuATIDuy++uHrM55V17AN8KNlfIYIHj+h/iD0yLpSmNuF7rukpTMKmSHGRHQGi5yZaSQgBPCRoxaZT/AeEkVdlJzi/4zOTwhnHhCqHc=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc4ODQ4OTg4MiwKICAicHJvZmlsZUlkIiA6ICI0MGZmYjM3MjEyZjY0Njc4YjNmMjIxNzZiZjU2ZGQ0YiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfRW5kZXJtYW4iLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWIwOWEzNzUyNTEwZTkxNGIwYmRjOTA5NmIzOTJiYjM1OWY3YThlOGE5NTY2YTAyZTdmNjZmYWZmOGQ2Zjg5ZSIKICAgIH0KICB9Cn0="}]}}}`,
	"minecraft:ghast": `{SkullOwner:{Id:[I;103843238,2038384517,-1105583667,1971386194],Name:"MHF_Ghast",Properties:{textures:[{Signature:"N5SDh9BCYT2hx6VjSeTt3UbMvv3QGaAat9y6Cu9KbvS4ItcjoWeT0387mP0LwkqL1GkqfuwZjmxdjBoMisxchy2MKtY8kYg6jvgJ47+enGaMrbVCG4fPxmbkmmm4oUZ+fN2zWXrqa990dXrJ+4Nwb5QVuqRVxov4iJqSsBpxDkvdrSOsHkVC7562oRf6V6m7YtrWUx4MGGKYL9P9nIpah+/u0PxLzUq4Qq2CyWBc8EpW528elFpaX14CochUmdGnBgQn4G8QvV7VakezyusyAJNWUON+iVYKVugeVL/muFKfolDOUxLdAtOnWo0sTG9rrYtDstwq97W81RB4gEZ+aZMQ7LnYNAtKDU7bdu0iL5ZHXeNDNicbWbiR67q7lUwffF1B2FSj8pJLvxR7NML+PbZM1ZQN37r/z5Y54jkS6BDlBTzepzo6ziuLwKX1VVeKXEJEca1cCVZ7D7xu8v2oPm93bRTBvqzVWd/ES5RAFPNaheiKYfxESgigCt+b5KsZnMPLsvKMxktyd29IiufL2umd7heZEtmjRT0GnIuT5WrlNdKLfGlajINXiP+AyrAuaCE4JuykqSd5IWJHmrCQXbi7hIoHmRai7ZAQ+H94O+2tron0J61gR0to1R8jvjF9CbLfYEsW82axCakrUu9cvXCYEJuiF08VFk2eeK2MZOI=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkyMiwKICAicHJvZmlsZUlkIiA6ICIwNjMwODVhNjc5N2Y0Nzg1YmUxYTIxY2Q3NTgwZjc1MiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfR2hhc3QiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGE0ZTQyZWIxNWEwODgxM2E2YTZmNjFmMTBhYTI4ODAxOWZhMGZhZTEwNmEyOTUzZGRiNDZmNzdlZTJkNzdmIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:iron_golem": `{SkullOwner:{Id:[I;1971294386,591678349,-1918074302,853724878],Name:"MHF_Golem",Properties:{textures:[{Signature:"BXAqKNDnzhNY+EP7aoOOwgqs1/pkRl6425mhOwMnX7iNLUrq1CSuLWe7ljlSzorpTknSp0KuBpCBkg1Uxb8TYnVbtilAwODl/NtFHL2bCtZXy/mGCEXTPKPuUnU5JYbJsTRiyFmgpb0VSWLMDuL5uSpUGIx3+8LxwpPqIboQxD6FX0f/PGyuG0OC4WgMjcO9XNDcCt8+2UTrZ1r2mJqUdlIA9WARWwcIEMm230mpFlU/QgiRb+yNI9JjLLVBAxmqnfb5OGXcPUj4404/1r1SqMowe7/WB1SrLcN9l3UXHmGIrM99hjQ07AWDXd6z3FAm8jvFQk9u+jpSx+hywvoJXrMv13BkW9HO7gaMz+PTtSATjM3ojojE6jSFV5sNFEaQ2e7WfJuymn9kQV9MmcaSvXp9gcO+pO7WhmPhfpv/gQP8la8i1jhE94HEyy469+/hOqI2+kZRiCMKfQN1ddQ5KN3qIdlrXxAUFq6QF57/4LFbo/5RcIE+yfxKSYgw4KpK5QuJtqG/9QO/yMv4LFgSRguMi3V+wnmEmsfyEK53wU9+eams8igaMB0R1WBRa9/XXxHf4hxJkdtNBWocz08k3XPB7d2Rnb4wwmzcfKUxYLVecuT6qFac/Qk6oCw3/lS1j9ZUduwk3sti8RR2uxRhEgKJ1nKpC7BpBfPtgM828sY=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0NSwKICAicHJvZmlsZUlkIiA6ICI3NTdmOTBiMjIzNDQ0YjhkOGRhYzgyNDIzMmUyY2VjZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfR29sZW0iLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMWM2Y2Q3MjAyYzM0ZTc4ZjMwNzMwOTAzNDlmN2Q5NzNiMjg4YWY1ZTViNzMzNGRkMjQ5MDEwYjNmMjcwNzhmOSIKICAgIH0KICB9Cn0="}]}}}`, 
	"minecraft:magma_cube": `{SkullOwner:{Id:[I;158514641,1267091963,-1630756013,-129426863],Name:"MHF_LavaSlime",Properties:{textures:[{Signature:"yR2qluD1xRA0MUYL9iiPDrbbGya7cr9cYI8BEPA2tfrKEu380RqB5Jx0BWDlGABwAACsDEXmp0vcKYq5251zNdiD1CWy0HL+vf2xPIqDyNRko7uU0N6O1fJGjYw1xV5CqyHRNgtDwXIWAKrn2gWcTsIFLv+F3PionJK/p31/A1igIrNjGU29SIgvYG5jUdA1QQXZAXatMu6LwFtwmbT89Gn9PHodfSiBbDIjGNMl6NsgyVCr9zJjz3T5XBMf+Pr31q8s2CdHdbS5lqiBZuDXjz0pI5X7/GVm1KNYXqyMXCmf1fFlzfiuYyE4JVHwDf++QuDAEALqRoFaoizGa4luY+VPaa41X+XjHjR+bJFSqt5QSHUYtNd+2dCJVS46dd0uFWwX6EW7r42POeAnMAJbmdBxltqGMGnpJ1XjEN7shYTRlS1860w+j11FQ/QZEUiLRTk5YvNjyezrxhMxvdRaCuZ0GyYeke3C+8zpx3qlmUqZp2C5rb2fd56UddqVcg3Zg4hsZYsvfWurOT8P8m8bHP85HtddoaEJRuCzrs449dWyqwMvs8iYkAnzJ4fKDC1tEZBS/xMaZUcW8EfAISuyk2fKEzfwqPmMviGGLQda6fpkY54QskWmJB+pwjaAtXABYUNC68ueKG9p/1QQvkq0vCoEThR1LSNi3OWsbAYAGlg=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzOCwKICAicHJvZmlsZUlkIiA6ICIwOTcyYmRkMTRiODY0OWZiOWVjY2EzNTNmODQ5MWE1MSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfTGF2YVNsaW1lIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Q5MGQ2MWU4Y2U5NTExYTBhMmI1ZWEyNzQyY2IxZWYzNjEzMTM4MGVkNDEyOWUxYjE2M2NlOGZmMDAwZGU4ZWEiCiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:mooshroom": {
		check: (nbt) => nbt.Type,
		prefix: (type) => type.charAt(0).toUpperCase() + type.slice(1),
		"red": `{SkullOwner:{Id:[I;-1536682026,1942310719,-1223512213,1072987030],Name:"MHF_MushroomCow",Properties:{textures:[{Signature:"MVfHkyX3Z/3bUUAGR9jiiGEq0qO83AVQ7L+XiG5wg4fs0NLGMYdL0z1LhhN/SSvmBWpZ40sBgtgEJ27jNfV1twmxjoNfeQgfl6vO27OaFkdoPdNWAau6FcyUBEkAbzbvdAHrPdT03QbrRef9PNqN4MjEhbOwN2YEPAM5PjdWrw9zN7ZZYPEaApFGMFZa1XJF5Ndaka/pu87R/xPm1fHjlp8NTw1KoZZo0XVVTr4x/aVRoD1fB1H8iVnpptQpcHq7n+aDy7jL/U7c3fwOiqhJcipXDJaIjriKBUG1bHIX+38UxtI2YE/MpleSvqP1wh6XkBf2kac+NeucrOTEHWoRoIVAHXyrERsaPJUxHjGABkwD9V34MYxtIiZRYNU8UdGw/8tMkx0AGoH4HhPoVV5Njr/HUsohS+ZSsuOda8uBLOeWpkGrmpdeyMDGInM24JTeaOWNBQoZsQpH1siYof2qw3G2aMzKXezPgxDH8DPWp8d2fDVjZCwU3/X25EnUMYRCKrcrJhGdcnj9X/4fMeFzIGIFUdmWi3G1UpQQCTK9yjar3wPAaZrub5di3cQepscM5elufX/mkAMeFKVD+jngp+keZbUEk8ilzv9roquy2hOpb8JK6hLy1+j3ZuAr+ocXTcuZ1xmOhfdXBEOp3ZbzOQh2Lhpj1ePD5zZjxWYI0DA=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzOSwKICAicHJvZmlsZUlkIiA6ICJhNDY4MTdkNjczYzU0ZjNmYjcxMmFmNmIzZmY0N2I5NiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfTXVzaHJvb21Db3ciLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTIzY2ZjNTU4MjQ1NGZjZjk5MDZmODQxZmRhMmNjNmFlODk2Y2Y0NTU4MjFjNGFkYTE5OThkZTcwODc3Y2M4NiIKICAgIH0KICB9Cn0="}]}}}`,
		"brown": `{SkullOwner:{Id:[I;-556814188,650268291,-1487594598,1813524419],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjFlMTg0MDU3Y2JiZDhjMDYwOTI3YjVhMmE2NmI3OWYzNjIwYzQ1OGIyYTAxODExMTc4Yjg5YTI4ZWRhYTFjYiJ9fX0="}]}}}`
	}, 
	"minecraft:ocelot": `{SkullOwner:{Id:[I;468622837,1332822690,-1085089415,1892941475],Name:"MHF_Ocelot",Properties:{textures:[{Signature:"QbbCnGsi35qAG63JeBj+IOGjkqOZwLFYmSlWTSNNw8pQvTkNGnGVvDv7fv7CXUXiSVhI4zQys2ilaO5yhv0UuTeXXt63uNK6NfcLe4K1eBfRtZYWOLqHUWtxUrAHlMoEO2G2/tAbA2ZgNHJoJ3Ec4i8W+k0xmmIjNdwzeDgwT03qWfl8e6f8Rnc9ur0v3pgtLbnfNWS9sDzYa9dZpV5uVD+G2jbZbynAWe0nQMafz2y61wyoamakwtoXkTgGdeqCMvgjhA7litEeNBkraaTQ6rfmpABWoQvwDAdKArLjt2p8eUKPLbSLpT1mcPiW5AfDv/b1ExXujfs/BnWP8AodVQPbDNbPIU1RYfYYAGEl1dlAXqzmngNFjjKm3UPZxKwL8cYPM22nsCoMhHN0Oo3YjoXnlqhyDr79Cts2kTLe7QnUi1JHTYElXPEcfn/WX6POucCJWsQ1iDJnLX2r/Ay6Tcrij7suZzxlA7UhNSTo42WuK4dKm0gZRJz8ZpnGNC0PfcBweCPp9yZY/GdxCEpmlbVRzlMP5Wne7UHB55FWsQMazMEFKM7ZN+lcGMxkB7Gz89Zmq1J5WRBKY8LALtKtPy2FhSpTjmGXUJ+Jp5Txox7EHJX8xUlNM0dwWOtvxlWuYi7ZG8HhabXKfMfyN2iNeAu1wGPCn3BYMkMr4WDi/Hc=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc4OTY2OTI2NSwKICAicHJvZmlsZUlkIiA6ICIxYmVlOWRmNTRmNzE0MmEyYmY1MmQ5Nzk3MGQzZmVhMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfT2NlbG90IiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzExOGI2Yjc5NzgzMzY4ZGZlMDA0Mjk4NTExMGRhMzY2ZjljNzg4YjQ1MDk3YTNlYTZkMGQ5YTc1M2U5ZjQyYzYiCiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:pig": `{SkullOwner:{Id:[I;-1957230709,-239254049,-2084251507,376868798],Name:"MHF_Pig",Properties:{textures:[{Signature:"yWV5I4VpNG0DiezHY8rTJ/NhfWEBCQFzQBRMaBIunhujsb4GSPDR7tev+LDpToGW4ZssclJVqeGyRp1730z7DEMJ72zDcLWgYinfLZc6ygQFEN+VDFuUIz0dUQ4y4Z7zGdBOY7qu77UKOqqfYVXPJgjKzZpnwWdr+ccD+roXh/X4JAzU6zNMQIl6m3yIHJl+VQWuXBMtsCqvNo1jfK+W7FSkIraer2B/38tKTPSIJ7uc9IEJBBYlemZz4xdRp4iMrgGeaDp06tn/R1pE8tFYZS4L5fdn54CgbGCEwZbaJfjJpaijR+LhzsAjgxT0xDXPUn4ORItXSIZaq4cnYP+GkH7EuDblE+8SABBsXvbraPhjg+j0WxKRBO/RnhgXEs3EPGB8Eu33eWqZgbFzv49IzwTj1/Z8pyH4t/mRZOQRuR3zZci/XqyV/uaMmDuaAxoGfaep+yhj+Xrz+u1aGZK7ZNy7M1b0CcJIhy4mJ1Pg0ZUaDjXTkK0FRvkwnhOX0Id3659y/sM6ccFfRXXXtTYw8c3H3GKWhJ5v/7iN5vN/sQR1A0rn3pcO02s47RSQ2CZwEQ2FfZSF5h8CPp68okXj1qlBqWkSY/sMJ1GcS3kyPwEte7lsYFWxXgibLZC+UziVEHrZU3AJ9jsv9O7qhkXsEQjUlgaNhl3G8wQZi/GdjUM=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0MCwKICAicHJvZmlsZUlkIiA6ICI4YjU3MDc4YmYxYmQ0NWRmODNjNGQ4OGQxNjc2OGZiZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfUGlnIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2E1NjJhMzdiODcxZjk2NGJmYzNlMTMxMWVhNjcyYWFhMDM5ODRhNWRjNDcyMTU0YTM0ZGMyNWFmMTU3ZTM4MmIiCiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:zombified_piglin": `{SkullOwner:{Id:[I;1325481211,-2064102016,-2060901102,2137813230],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2VhYmFlY2M1ZmFlNWE4YTQ5Yzg4NjNmZjQ4MzFhYWEyODQxOThmMWEyMzk4ODkwYzc2NWUwYThkZTE4ZGE4YyJ9fX0="}]}}}`,
	"minecraft:sheep": {
		check: (nbt) => ["white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black"][nbt.Color],
		prefix: (color) => color === "light_blue" ? "Light Blue" : (color === "light_gray" ? "Light Gray" : color.charAt(0).toUpperCase() + color.slice(1)),
		"white": `{SkullOwner:{Id:[I;-98350811,-1648473201,-1522238352,-76846395],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjMxZjljY2M2YjNlMzJlY2YxM2I4YTExYWMyOWNkMzNkMThjOTVmYzczZGI4YTY2YzVkNjU3Y2NiOGJlNzAifX19"}]}}}`,
		"orange": `{SkullOwner:{Id:[I;-1043471601,-2001908475,-1569165870,-1159092992],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjA5ODM5N2EyNzBiNGMzZDJiMWU1NzRiOGNmZDNjYzRlYTM0MDkwNjZjZWZlMzFlYTk5MzYzM2M5ZDU3NiJ9fX0="}]}}}`,
		"magenta": `{SkullOwner:{Id:[I;-549258766,-2031138674,-2025160828,955608406],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTgzNjU2NWM3ODk3ZDQ5YTcxYmMxODk4NmQxZWE2NTYxMzIxYTBiYmY3MTFkNDFhNTZjZTNiYjJjMjE3ZTdhIn19fQ=="}]}}}`,
		"light_blue": `{SkullOwner:{Id:[I;811396027,-924694804,-1800978944,-656625396],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWE2MjRmNTk2NmJlZGQ2ZTY3ZjY1NGI1OWU5MjQ5YjJlY2YzMDdkOTAzMzM5YmMxOTk5MjM5NzdmNGM4YyJ9fX0="}]}}}`,
		"yellow": `{SkullOwner:{Id:[I;-189466487,1289438606,-1937354535,474750089],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjZhNDExMmRmMWU0YmNlMmE1ZTI4NDE3ZjNhYWZmNzljZDY2ZTg4NWMzNzI0NTU0MTAyY2VmOGViOCJ9fX0="}]}}}`,
		"lime": `{SkullOwner:{Id:[I;756743143,-1773058569,-1083245962,1206741570],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTJhMjQ0OGY1OGE0OTEzMzI0MzRlODVjNDVkNzg2ZDg3NDM5N2U4MzBhM2E3ODk0ZTZkOTI2OTljNDJiMzAifX19"}]}}}`,
		"pink": `{SkullOwner:{Id:[I;-936466997,-389001351,-1162854581,-1041753250],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWU3MzhmNTZlYWZlNmZmYzE1ODNkZTgxMWFlMDU3ZmYzMDQ5MWM0MTc0OTA1OGJjNTI3NTMxN2U3MmU2NjkifX19"}]}}}`,
		"gray": `{SkullOwner:{Id:[I;450274176,-45595680,-1477814651,120534966],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDI4N2ViNTAxMzkxZjI3NTM4OWYxNjZlYzlmZWJlYTc1ZWM0YWU5NTFiODhiMzhjYWU4N2RmN2UyNGY0YyJ9fX0="}]}}}`,
		"light_gray": `{SkullOwner:{Id:[I;-1758259305,-820559577,-1303359806,-389282296],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2UxYWM2ODM5OTNiZTM1NTEyZTFiZTMxZDFmNGY5OGU1ODNlZGIxNjU4YTllMjExOTJjOWIyM2I1Y2NjZGMzIn19fQ=="}]}}}`,
		"cyan": `{SkullOwner:{Id:[I;1686435536,63261832,-1323186314,-584784204],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDZmNmM3ZTdmZDUxNGNlMGFjYzY4NTkzMjI5ZTQwZmNjNDM1MmI4NDE2NDZlNGYwZWJjY2NiMGNlMjNkMTYifX19"}]}}}`,
		"purple": `{SkullOwner:{Id:[I;-10741454,-2137634991,-1144029683,-2009614143],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWU1Mjg2N2FmZWYzOGJiMTRhMjZkMTQyNmM4YzBmMTE2YWQzNDc2MWFjZDkyZTdhYWUyYzgxOWEwZDU1Yjg1In19fQ=="}]}}}`,
		"blue": `{SkullOwner:{Id:[I;-598732144,-688762942,-1530678050,1761325973],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDllYzIyODE4ZDFmYmZjODE2N2ZiZTM2NzI4YjI4MjQwZTM0ZTE2NDY5YTI5MjlkMDNmZGY1MTFiZjJjYTEifX19"}]}}}`,
		"brown": `{SkullOwner:{Id:[I;1760768774,-1193130197,-1739691515,-323801757],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTU1YWQ2ZTVkYjU2OTJkODdmNTE1MTFmNGUwOWIzOWZmOWNjYjNkZTdiNDgxOWE3Mzc4ZmNlODU1M2I4In19fQ=="}]}}}`,
		"green": `{SkullOwner:{Id:[I;-1504277081,-604159100,-1624094105,-169830192],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmRlNTVhMzk1YTIyNDY0NDViNDVmOWE2ZDY4ODcyMzQ0YmJlYTU0ZjM2MmQ1MjlmYzViMGI4NTdlYTU4MzI2YiJ9fX0="}]}}}`,
		"red": `{SkullOwner:{Id:[I;-1304925254,1014515052,-1131370127,1827443645],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODM5YWY0NzdlYjYyNzgxNWY3MjNhNTY2MjU1NmVjOWRmY2JhYjVkNDk0ZDMzOGJkMjE0MjMyZjIzZTQ0NiJ9fX0="}]}}}`,
		"black": `{SkullOwner:{Id:[I;-159378331,-49854471,-1834927383,566488837],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzI2NTIwODNmMjhlZDFiNjFmOWI5NjVkZjFhYmYwMTBmMjM0NjgxYzIxNDM1OTUxYzY3ZDg4MzY0NzQ5ODIyIn19fQ=="}]}}}`
	}, 
	"minecraft:slime": `{SkullOwner:{Id:[I;-2029340013,1088964787,-1983565076,-535992784],Name:"MHF_Slime",Properties:{textures:[{Signature:"t372vnn7ONEtR7H7JbPfAponrL1bYRMM7xryuHQ8FZVy9hAZBSUCZMppBFc6mLTchy6MKCowU22clZp41llpKwSf5+tOg2TD04Kf4WoGzFAhHaLVC5sUEIucnQ0BiW4+oMJ6T33SWmVRZd10uviZ8QdNgVLR4MsAc56OW4/yzhHfpIVaYQe4hRI6aOeE+u4gmZU0kK4ivEN2kWaHSCuOvSrhdzK1KLZ6bayCETkA7XtIQ/gqr69YDLWmeXUanGp9Zh3Xq+ftmh2KqNySs1Pxww1ev2kHhw+yMNXzErsGgLSmXLtV4DKo4M4y5z9FC54XM/Mo3EggwGO/dxES8+7H6gT7MoImeMx8cOI6K+6+F1S192vD7RRm7Go5N2kYHXGWhDRltC4zHTkjH+sIKXeG7sYjx86T/EliX9y/u+h6Tj8Xgwjq2Q69vm14I7/i3eLsDGQ3xXXgYcm2QfN0NHeYxqEOMxmGvnRs+unSSYNtgOBs0YkiKagA6pHhIbkx7Ug9JSHVhXokXl+aMaW0oJLPV+aIK6OkwYaD3ebAgXTLgw6XVh7rbYgTCCfwaLnJ+zFR9t64N3Yv9oaoKvQsXegZuVwy8FaCrxW2BsLcAt/iXRdFd88G+5syU09mZzm5WXEBdtEYqMNmIQ4v0m53zKQgiaI3eyjDLDM9Gq4uy8LMeKc=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0MiwKICAicHJvZmlsZUlkIiA6ICI4NzBhYmE5MzQwZTg0OGIzODljNTMyZWNlMDBkNjYzMCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU2xpbWUiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODZjMjdiMDEzZjFiZjMzNDQ4NjllODFlNWM2MTAwMjdiYzQ1ZWM1Yjc5NTE0ZmRjOTZlMDFkZjFiN2UzYTM4NyIKICAgIH0KICB9Cn0="}]}}}`, 
	"minecraft:spider": `{SkullOwner:{Id:[I;1523932980,1102466002,-1674438504,1013143862],Name:"MHF_Spider",Properties:{textures:[{Signature:"GFwVkeH5qe7aO36ZJ5IiGZAc9BDL+Cv4w2gMbCgYztySL1zJaDKIRVQWkRYQ24tEKPNESrzZnXOsyuiItSZxc8sn2nFJ4cDzrHQAzpnR4jq7rppcybMaQr/A3gxrXLJ199jGhXRHmsNG15FSUYYaly3Zw54UffCkLy2/3gzcnmbBpynqygYXLPdNLJ5rlzrEHEowG707xXGVg4UTSupUoEsjmJu8bWWN06OsOskjIxb0YnInHLfMnI69HkNgi1JUTCadIeU6+f0Ei4uIyg/n/ssA3hqctwUMxTw3PJqu12COR6HqLJaS1u1DNLLCwjpMMqMl1j3Qx3b4BQfGQsfNImMbMHOyR83x664i+PbNccZxrdIRpccmtUExvo/cOKHCoqLMnjZgaLRZ9vu7NapGthPWA4rb+pgruqoBmlF6sH6ewueiYPMOvfyPGwJepIZQQqeKsnvMdsMryod5ROsHJJQwEHIJwkeBKjek8yHHHcUTwGl5t9oI+08ZpBmOOt0QsQpVVrDszfuMrB07jjhIuCZTPe0qV4faW4xnK2PP+n1pgynIngCQvQX/R4JdhRjzKObgCLW8LRCrykb/GM78briGpaH+FUwAl2lbacnYCNvvP6SIlWSiO01xwnCCT2sd2qBlkBihgFVkraMYbRfH+4B9DIKbr6hXeTY9iDPh30s=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDExODA0NCwKICAicHJvZmlsZUlkIiA6ICI1YWQ1NWYzNDQxYjY0YmQyOWMzMjE4OTgzYzYzNTkzNiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU3BpZGVyIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2Y2MWE0OTU0MWE4MzZhYThmNGY3NmUwZDRjYjJmZjA0ODg4YzYyZjk0MTFlYTEwY2JhY2YxZjJhNTQ0MjQyNDAiCiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:squid": `{SkullOwner:{Id:[I;1927693955,-485274570,-1542928789,1693010677],Name:"MHF_Squid",Properties:{textures:[{Signature:"OaEhNiW28D92w84DlAa3cQPd6GlHsVHxLJr1NCgcSoTfug56cjtUTWGcYPxc9VqjYav59DUwrJmfpU+i3HCiw4ZMXAMVnEejATmldUi5JdWTFx3pl7PUoHUGxY8vAhlWjzrePVEbeKWNmIVqZ68xb4ChrMvHE6NvbBATehqa/v9KoQtYXH0h3w1vLf1FzFSCeKWyEXU8O0LCSFkW6UgaTxg79ONvUSJ6hUu6hUBAwiwKzsqPP2HELas3wuIcbOAKo+Em10ElzQMzgI2FCGGgEn/3YxRFJLku+hGCcIkgrBpspWK6GPh8zXYAuMLnsyhd6rXP50GfYBZ7Dh71kar/4L6MZKMBDIXR6rfb19AYXUZcl7C5/zC4VKZ439woSYhE3dFukAKbdHdV2nqV5DbdqUu3D0Y9B0OKU8fKP3NwqiTunHhcpgxfgl1ODzaO09Vh0iq5t0+D9SLWfN3cWYrM+AOhobCDXu5yTpohx28cequrvX8dHDOqYd3cgrGOzexkwM6b+J/r+W2ozSYb2z4hQoLtOhJQQyLH5fh/HKDBGdKh1ZWudxDSXSuXdDa+lDhLsPueLTY9sb2BiPvXGp4N/EQbjxnfGpki25VuXxkPXVlhFvMawsxFPoDZqWquLy3k2aNx6w+xiq0dSCS2SayLwVvuRc3HF6Fzvo6BU+Jif8c=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NjM1NywKICAicHJvZmlsZUlkIiA6ICI3MmU2NDY4M2UzMTM0YzM2YTQwOGM2NmI2NGU5NGFmNSIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU3F1aWQiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWU4OTEwMWQ1Y2M3NGFhNDU4MDIxYTA2MGY2Mjg5YTUxYTM1YTdkMzRkOGNhZGRmYzNjZGYzYjJjOWEwNzFhIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:villager": `{SkullOwner:{Id:[I;-1119344839,1987855836,-1577532612,1079183698],Name:"MHF_Villager",Properties:{textures:[{Signature:"clazTqEYppzyZHwjjc5cniFQ8SKQ/SQf9zdyxGIKnhgu7eId8FtYVOJqEOqL9mzhmIzfiU6LREt1zIRZNDTSW2d35eKds+yvr41HLRgIH0TZMYByUeE/WqW2tfTJcrBgQZX2xkMd4LaiTZJCjIIBTkzmpRjeYLbdamkg69kcOFNCZUkPo13jbUdNXBB2nZ+/TUZtAxG5/hKh6JgZPXZsQyi/sOA8RwllZwAkttehjSpVvEWNl6WY4EXgvFqnvntzavfIGtsQcRaECD1R3Z9bBHbQJXWX3ZRXxjsz3nB3ED4bpgZ2Gtu2U2Snfn5TOttS8UlzRZzks/jRGx5YCanGXUvGxRM5qxpW/dIH22/pvtcPG1/CJh4ITKHq1mkI/KmRFXjNl6tKAvp9AAEElgyoi6cjXUIG8CtPc0i9DfgzHVuEHoLvQ/RipegCuq7vzIV8zybMEfwDCQbI+xgcJsghzC8McwL0zDkuTPo/fMLtOmXufJpkK+ztbBp1Soz2sUM97HyA9vWGv9xuuIpYwr+jrmDvve9vlFh/SW0/5+rofJy/ST8qnO5fZcbpNmrKVU7e+/hSd745RqJYrOmi/uZN47QxJ0MkOvrLwn2J8/WC6ezPxpMFwfg88D6xX5FsPZay7rGtTbJfD+IUz6Ed+qg1JGAPdRCxfLU7UOKdptMu6CU=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzOCwKICAicHJvZmlsZUlkIiA6ICJiZDQ4MjczOTc2N2M0NWRjYTFmOGMzM2M0MDUzMDk1MiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfVmlsbGFnZXIiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjRiZDgzMjgxM2FjMzhlNjg2NDg5MzhkN2EzMmY2YmEyOTgwMWFhZjMxNzQwNDM2N2YyMTRiNzhiNGQ0NzU0YyIKICAgIH0KICB9Cn0="}]}}}`, 
	"minecraft:witch": `{SkullOwner:{Id:[I;-17277879,803162104,-1858972384,1176777251],Name:"MHF_Witch",Properties:{textures:[{Signature:"sHIS03exKMKx0HMIN9YUEX18W6WGuwPFS/HbVi/EB2YmZW3OW726xs4O0iY5uM8V0WGX+u3LIgngjRZ6Gqh8YE/9Wd5G9NbC1nyrf3V6xsVOIW14zUfQlJvdLtZUeNV9Yu8Lsu12s+goeyBR6aWzKrTztNm2dzJ185Dp2sx5/N2nNuQHlWXXvY+n93+nbcRCqdA/s3bvX/Lp5SsApZGc8qtu2ZwOgZu3ljbxPWcLDiJ7p+OJ2XrO3V3vXewcY4lQ0jExmujhmjbyCLTard4MRZV6BwKUpz1sjqx9rnVUXwl+0cvSOi6zIVUXbSgRycPg01/REhnrFkPDqzGsAMYZQq0i4L1HfYS5zWeN80sxVJM9F6q+1a4uh6Ki4GETI3TziU/igoHX7TXtKcnpXuWwVgnvw0ns4I9bKuEl1x79b1NHL0UN1AxS7HBQcxgR4NE5cFHHZCk8Pg/4+X2c7E5uRBWayxD6VPOSeGoIpTOv0TCC9sXT+9EUnZvZVBZJlq4khZr/HUQ6tvXwYX8JDemO2Ky3GJ0D9y5DQvmEMEJhjAeToRLuPlwMrTX6NkxROvm/5G4cFJNwZiSKbvVHNIZi3sKxcgIkNV89IBi143aIJi709PuIQeFOGDYXn0ed/tepI3D5+qlGJWA0XNQlOVLqJs9F12IVpBa8NNgRKCwGAbI=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0NCwKICAicHJvZmlsZUlkIiA6ICJmZWY4NWM0OTJmZGY0N2Y4OTEzMjU1MjA0NjI0MzIyMyIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfV2l0Y2giLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjBhNDY3OTliNmNlNGI3ZTI5YThkZWY5ZjU0ZjMwY2M3MDI1ZTk2MzIxNjI1ZjJhYjQwYTlkNzBiODQzNmIyMSIKICAgIH0sCiAgICAiQ0FQRSIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjM0MGMwZTAzZGQyNGExMWIxNWE4YjMzYzJhN2U5ZTMyYWJiMjA1MWIyNDgxZDBiYTdkZWZkNjM1Y2E3YTkzMyIKICAgIH0KICB9Cn0="}]}}}`, 
	"minecraft:wolf": `{SkullOwner:{Id:[I;-1926423187,-2144056183,-1115258726,838685075],Name:"MHF_Wolf",Properties:{textures:[{Signature:"Mv1ogYwQy/TtUnzQG7Ov34oNiJ5mpHJCHbkhnE+7GcDhAx6IxB3EkEZxyqwMDZi1RupBBWxzZDlLBpT5K3atnrPD26ataCtbXoFU834kmUcHhP5o1u966bvI1+X4K4uLju4MJS3vheovpfCE+Uz2lg9zb1QeD8DX4wmp/qGWxgQNFdnfEcnJ5gNjjAlPwqWxXy63iMhTb9lMu1blVSIu5+w7TrL/RpSP6BBINi+K7OU57PE/EUuvpijb51gmXyoSmG8/o27AUVss8XhfXaATrbBqbnu2d9YTYmuty7kXMYrCW3bm5nKB/aOU8qS5ZvNyQuVClfP2pwLY20ZKHg/IzJlGQxSXSpCeJW49SUpsfZJLd+NrVUV/3HSKlkqwP/LUH00amEN9hdxN5brIDIn74sDjW3r2DjFpISuWn+hHp0Gepl5i1cXPXGReSshx5+yYwBWe+eqlbyt224HcvQKCffmaz8mLCjN2Mhlz6HsNxXPoli7/mzpgE23GMAqdHPBsGX/PjIhLi+zecJbEw7TmeyI2evYjjR+vxdjsdLSHRz6A6Kd9wia69HA5dZxnKLl5xhJY6/5hR1Mx65kYsxazm+wdJyFCjuLkWC9ck2LzOmO+Nouz1dOT14YKD6XtGggIXOCVOUifc3m+SmA2ORlOj9sM9pVYWTElG7f7Xv9CW8I=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzNywKICAicHJvZmlsZUlkIiA6ICI4ZDJkMWQ2ZDgwMzQ0Yzg5YmQ4NjgwOWEzMWZkNTE5MyIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfV29sZiIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS82OTZhNTM3YTgxM2ExYzE3YWI0YzkwZDIxMmI4MGQwM2IxYmFmMWUzY2YxNzJmNWZmZTAyYWZkMDUzMmZjY2VmIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:guardian": `{SkullOwner:{Id:[I;363465835,-781889610,-1078169931,880891869],Name:"MHF_Guardian",Properties:{textures:[{Signature:"px4pay52BtMsSGISveL1TEQWqzYDx824KhBpizaTZ224lvYdiPfNWLqHW81hFf8NakkKb8YNks6rPsfZrhEzv5b7RJfelb7XxEryEHKzipWaqcYafvnbKzWl6metUnK+QoOQ7XhIU9HOImgOvn/EjiFh3cm57/8SZ7C+INtdnZtUOmjg4bC9AEWZJt4pzZ8NqpPUDk8H05Po7X0zJIIl/XJeKK6PfsZuRLI8cKCR7RbPuFQj0cphf/1N3LJ0JEJ+mGHcE/J3tJzkpoMn1V/cQ03NiVVVXuTGDePj2oMEH0K80cM6rg+5rHyMV/ZNEE0AvYSHEpRJ0HjAg/fwHohLP6/TLqbWjD9eK5LQVPY+hjhpK+TxS9nKYJNyID2jaA4MULX0k+3PbfK7f6N3IV5kH8iK/PnBzcy4YHQgcHG0w1UcKgK3+8/P8VjEc7Z2yHzQATpaZuTUi6Bz9CuXEZYu6DHttYoihqlBHkg7VGG25dGRQ/siiGOoDBuyxiUz4j2yocWhfgDC3diSXC9YOwC6C0svQzAMcV6a4eYC6VGN+N8C18GugqE63Av2gw0N2RvJKIquM3ggwItM6h6lE3LMda6+6fgrQiJq4i+IgXueP0I23tXoLNDPcDLnU2eWQk5jIVG2DCQZDZGU+9Ok/ZN7oGoI94GuaNUFwxphaNjKePU=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTk0NSwKICAicHJvZmlsZUlkIiA6ICIxNWFhMGM2YmQxNjU0ZmI2YmZiYzZlYjUzNDgxNTdkZCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfR3VhcmRpYW4iLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmExMTViYWM5ZWUxMWNmYWY5YzlkNjIzYTM4MjNiMjFjZmJkZGMxYjM3MzRmNzFjZjY3ZmUyYWMwYWVkMTc1YyIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:elder_guardian": `{SkullOwner:{Id:[I;-1647703341,-78099849,-1601399648,860602819],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzBmODY4Y2FmMTljZjIxMjRmMGZlZjk4ZTZiODc3M2QyN2ZiZjQyZDkzYWFiMDZiMjJlZTAzM2IyYWVlNjQ0NyJ9fX0="}]}}}`, 
	"minecraft:snow_golem": `{SkullOwner:{Id:[I;562011742,1612663357,-2019827443,820241819],Name:"MHF_SnowGolem",Properties:{textures:[{Signature:"A8j6Tj5POKnZw9YVmbuToNopByjomz0Qp6Hf5jXKAVuIW20LgPDkFFYuGC2YIRupQTC5AcvXwIKiv+vofLBJeoZ/bKT5OzHGyRcNt8DIIWMvutTNksJtWXqcrtSW/aw/UC0Ul3iKkZhIiq5yJGUNeSYeV2VMAvCgj9oFffi5oiKgJPGp/Q+VF6ngsz5Uu4hz7qg1dvye90lusAV8W4Yl7MxGdhyQ+IYvx8Uct9wtpNvOEEDFqEfdtYU0XkPQazGoizYS6buuySb1bdM/LPRXyUhm0P/baMkm9qGHDCYIgGmrLG7YvaCRtR8HjS9NLhOSj68ubmxv/elLF9YeK6T0ZT82hVOM4ZxrK9S+C1gn2my9ki59RP18B3Z4pgrnisEvgtZ+4ddT+P+ieg5Rr3+kpbsMMMfW6thz9+la2JMYEhIC+BKdTrcxxkDe2lQ0vrasOYqAbRUiFhnS4OkTx4HE76kWhCdLBeen+APWZBjHDW86AvaSJnDr8NRAS5T+4psZ9ZiRh1EEZNByVr5K5J7X2VxzrZPDOlIV+B19trfBprACN8AMoicMU/aPya/3Uappf8rKvOrpz9bu2h7iUhLRAzQ0fggiH+I7LKumxz1ueVQmqtSe0MZ25nsY27rKSIYnIcTpZ1Uty0/nJGPNhS/QKAKRYalhv3eq8/THiBr9h2w=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NjA2MSwKICAicHJvZmlsZUlkIiA6ICIyMTdmOWU1ZTYwMWY0YTNkODc5YmUxMGQzMGUzZTU5YiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU25vd0dvbGVtIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlL2YxOWMwYmY5Y2VjYWU5YzdkM2VlMDUxMjViMGE5MmU1YmE0OGU5MDY4MGU1OTk3MDUzY2I1YzA3ZDI4YTBkOWMiCiAgICB9CiAgfQp9"}]}}}`, 
	"minecraft:silverfish": `{SkullOwner:{Id:[I;-1228138065,949633952,-2066541932,-1734875160],Name:"MHF_Silverfish",Properties:{textures:[{Signature:"d/letpjIogix4wm4qbfkSFsBzdWRqe8el9fMKRNqSL2Aum8CMoYywYvMKKmXk5ssMTBOTu5S/C/jhGRjelV2T4EDy+49xLSF//YzH74lElQs7iY9Jox7Xt4hz0EkogQIzemNVv1BDQ1EijGQetOTPDT4jUh8ZD1OrZQX2FuGU3tCGxf04L0cUCqLrYKNZMyzTrblg+o/sZ4OPZdTR5oyrPs0KyEnQLR0UD76O7TwChKTVqY+XiVrKMEqw0lKEsfWD0ILoRgAwmH8hywbLZpsDfZs/WlXEetHQ0TnXy2+zbuPNQbncS+k5USi7koaH+BidaATSl8zQFFKTCANNXmLpOgSrNP0e6hnKKZVhGANeiBdG/E+WhpWNPZr4Wbi6+ZJLoEhEhef/Oga+PK9eRWtx87tSaOlk5F6/97eEr80gFbZ/z59yJc7wIXaskF6cF2BiDlISWY/6+H2RNd12ei9in204qG2hZUJCh6kyfzN2SyzYd5xJ7G3NPDclZwKQdkYha9U+FAdy/I0oWTeS9kosoQ8ovCU+YMwkRlXHv+ANXOuPVTnSMI4zRl0zfCPaqzE6J0whnlZgCAHdcREywue4x8nd8G9KPhSc/Tdx6zZLCEqX+ZGT5qO1AKp4nxBBT5Ye3rDTRiVwrNn8hBENybRh+x4QY+3IVflwBZMMDylVeI=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NTkzMSwKICAicHJvZmlsZUlkIiA6ICJiNmNjMTlhZjM4OWE0M2EwODRkMzEyOTQ5ODk3ZTdlOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfU2lsdmVyZmlzaCIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS85MmVjMmMzY2I5NWFiNzdmN2E2MGZiNGQxNjBiY2VkNGI4NzkzMjliNjI2NjNkN2E5ODYwNjQyZTU4OGFiMjEwIgogICAgfQogIH0KfQ=="}]}}}`, 
	"minecraft:endermite": `{SkullOwner:{Id:[I;1039573072,-1187099253,-1885031134,-1971750012],Name:"MHF_Endermite",Properties:{textures:[{Signature:"cNEp0n+piivMtxVgkHzEAYAG5SqJpcSt7/m+eRCr8Wyx4KwCMWEK5q1tONCn7gjJk8TsZQFjgIOP2MEjRUldeupC86JFJw6jqkp55guYWkI3eqiszkMref37cwjoJ4AYP7rfqCawtX3MLWMpz6m/jMYZ6Oa6HhprLueGvRTRe6qbJQW2AZ/Ab+AJ8ppHgWtJfDt7A6nY0CtF/il4/Ejk0J+0SXLSPm+oCtcNKzC6Y/75C+OkzWDGRSVWxZ8BHNci7X8uk27UsLhygHCDO8sZaoBjz5Kjwg+/r4Xls0dFZOQSSFyy5HGtWsYTbPFiPoobfgVyqpz8y3gW3geKJlcy8KewTqjoABuIUPkQtG1DoxDlWGItYmVelncptEKirhTOT06vMxCQRdQp/YxwE/BUGD1D144Ii1hVh2lMdb4C9pC9OY5x8rH61kt+U7/BZIicauS6jLpT1dBK0gLmjIvxzY5XZNCmmJ2JPoa7ZwgA0GdZN211RMd0tq9MZ1JAIgXKvEZiNV8jjhGKFY9FTb1w9neZABLY5Qyi0o7ImXdWd9KxcOzoYJ0vlroDoMDqvmxrLFEpNF1vxxPsjkvBwmoCqLoYPqZ7YwKQp9yJz5NpsNcn17iFBzDdpDPTfIiRrJRoJ3calImiF555I+F3sWlnFCEqTeonEUCLJ4q6dom3IQs=",Value:"ewogICJ0aW1lc3RhbXAiIDogMTcyNDc5MDE0NjAxMiwKICAicHJvZmlsZUlkIiA6ICIzZGY2YTA1MGI5M2U0ZDhiOGZhNGI1MjI4YTc5N2I4NCIsCiAgInByb2ZpbGVOYW1lIiA6ICJNSEZfRW5kZXJtaXRlIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzE3MzAxMjdlM2FjNzY3NzEyMjQyMmRmMDAyOGQ5ZTczNjhiZDE1NzczOGM4YzNjZGRlY2M1MDJlODk2YmUwMWMiCiAgICB9CiAgfQp9"}]}}}`,
	"minecraft:piglin": `{SkullOwner:{Id:[I;-1456405078,2061059177,-1487049358,1405924713],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTc5MmI2OTk3ZDczOWY1MzViZWVkM2FiMWQ0YWVhZGZhNzY3NzdiZjhlMzhhNjY2ZjU0ZjgyZmY5Zjg1ODE4NiJ9fX0="}]}}}`,
	"minecraft:wither": `{SkullOwner:{Id:[I;-2026216927,-1384166262,-2113639875,557215929],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzRmMzI4ZjUwNDQxMjliNWQxZjk2YWZmZDFiOGMwNWJjZGU2YmQ4ZTc1NmFmZjVjNTAyMDU4NWVlZjhhM2RhZiJ9fX0="}]}}}`,
	"minecraft:warden": `{SkullOwner:{Id:[I;-1381416959,1014252740,-1104851937,-1153494372],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjhjMjExZDY2YzgwM2FhYzE1YWI4NmY3OWM3ZWRmZDZjM2IyMDM0ZDIzMzU1YTkyZjZiZDQyZTgzNTI2MGJlMCJ9fX0="}]}}}`,
	"minecraft:allay": `{SkullOwner:{Id:[I;-1806152798,1949450297,-1342206695,219969364],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2VkMWU4MmVmN2MwNTlkZjhmZGU1NjFlM2VkYWVhZWM4MzVjNmMzZjA3MmMxNjgwNWRiNjBiZjkzMjlhMmI3NSJ9fX0="}]}}}`,
	"minecraft:axolotl": {
		check: (nbt) => ["lucy", "wild", "gold", "cyan", "blue"][nbt.Variant],
		prefix: (variant) => variant.charAt(0).toUpperCase() + variant.slice(1),
		"lucy": `{SkullOwner:{Id:[I;-894503094,127615754,-1455150663,-1278500835],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2I5MTBmYmMyMTZmNzI0ZDI5NjU1MTU1YjJhMzg1OGE4MGYyMzRhMGNmZWQ2MDllMjJmYzY3MDY4M2FiNzc3YSJ9fX0="}]}}}`,
		"wild": `{SkullOwner:{Id:[I;1820228223,-2110305782,-1699672485,-136273793],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGRiMjJhMGVhNjJkNWQyMjg2N2Q4NTJkMDFkMzk2MTc3YjdhMGQ2M2UxOGNkYzVlMjlhYjM5ZjUyNDljNTA3NCJ9fX0="}]}}}`,
		"gold": `{SkullOwner:{Id:[I;1269302341,1053771813,-1867594777,-2123870204],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTE3ZjhlNThhZGY4ZTFjNWVkZTQ1MGQyMjM1Y2ZmNjEyZmMxNmM0Yjc0NDkwYTBlN2RiZDU5MzBiOGM4M2U3ZiJ9fX0="}]}}}`,
		"cyan": `{SkullOwner:{Id:[I;-270417045,523387817,-1225626442,-629593831],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDU0M2JmYTRlYTIzMzQ2NjdiNmFiZmU0MGQ4NTJlY2Y1NWY4NTA2YTljMGM1YWQ4ZGQxZTczMmY1OGQ5YzZjMyJ9fX0="}]}}}`,
		"blue": `{SkullOwner:{Id:[I;1647954484,207572712,-1325553647,740374672],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2U2OGRjNTlkYmU3NjdhNTI4MzE2NGUzYzk0YWNjMTRiYWRkMzRhODU3Y2VjMWE2YzlmMjZhMjhjZWQyOWM4MyJ9fX0="}]}}}`
	},
	"minecraft:bat": `{SkullOwner:{Id:[I;1331404383,-1076739259,-1376811539,1267859806],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjY4MWE3MmRhNzI2M2NhOWFlZjA2NjU0MmVjY2E3YTE4MGM0MGUzMjhjMDQ2M2ZjYjExNGNiM2I4MzA1NzU1MiJ9fX0="}]}}}`,
	"minecraft:bee": `{SkullOwner:{Id:[I;-51684637,-1005828849,-1121744131,-626684176],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODg2YTUwOWZmM2NkNDcxZjFiNDI4YTE5NGI2NzExNDcwYTU0NzczZTVkZTZlZTA3ZjdlNjAxY2M1ZTc1YTIwMCJ9fX0="}]}}}`,
	"minecraft:dolphin": `{SkullOwner:{Id:[I;-1954755219,920537056,-1923453081,-1715011912],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGU5Njg4Yjk1MGQ4ODBiNTViN2FhMmNmY2Q3NmU1YTBmYTk0YWFjNmQxNmY3OGU4MzNmNzQ0M2VhMjlmZWQzIn19fQ=="}]}}}`,
	"minecraft:camel": `{SkullOwner:{Id:[I;-121949146,981549351,-1398872047,-1629999303],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmE0Yzk1YmZhMGI2MTcyMjI1NTM4OTE0MWI1MDVjZjFhMzhiYWQ5YjBlZjU0M2RlNjE5ZjBjYzkyMjFlZDk3NCJ9fX0="}]}}}`,
	"minecraft:donkey": `{SkullOwner:{Id:[I;653565582,605307108,-1099301639,564993298],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjNhOTc2YzA0N2Y0MTJlYmM1Y2IxOTcxMzFlYmVmMzBjMDA0YzBmYWY0OWQ4ZGQ0MTA1ZmNhMTIwN2VkYWZmMyJ9fX0="}]}}}`,
	"minecraft:drowned": `{SkullOwner:{Id:[I;-1943150917,724453901,-1528537058,1492972198],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzg0ZGY3OWM0OTEwNGIxOThjZGFkNmQ5OWZkMGQwYmNmMTUzMWM5MmQ0YWI2MjY5ZTQwYjdkM2NiYmI4ZTk4YyJ9fX0="}]}}}`,
	"minecraft:evoker": `{SkullOwner:{Id:[I;270395103,-1326821974,-1814853546,887494179],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzQzMzMyMmUyY2NiZDljNTVlZjQxZDk2ZjM4ZGJjNjY2YzgwMzA0NWIyNDM5MWFjOTM5MWRjY2FkN2NkIn19fQ=="}]}}}`,
	"minecraft:fox": {
		check: (nbt) => nbt.Type,
		prefix: (type) => type.charAt(0).toUpperCase() + type.slice(1),
		"red": `{SkullOwner:{Id:[I;595207761,2108179834,-1427491052,-1128163678],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDg5NTRhNDJlNjllMDg4MWFlNmQyNGQ0MjgxNDU5YzE0NGEwZDVhOTY4YWVkMzVkNmQzZDczYTNjNjVkMjZhIn19fQ=="}]}}}`,
		"snow": `{SkullOwner:{Id:[I;-1299416143,-1230419589,-1976749208,1994939037],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDE0MzYzNzdlYjRjNGI0ZTM5ZmIwZTFlZDg4OTlmYjYxZWUxODE0YTkxNjliOGQwODcyOWVmMDFkYzg1ZDFiYSJ9fX0="}]}}}`
	},
	"minecraft:frog": {
		check: (nbt) => nbt.variant,
		"minecraft:cold": `{SkullOwner:{Id:[I;2027783430,-1881519299,-2008919016,-865785471],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDU4NTJhOTU5Mjg4OTc3NDYwMTI5ODhmYmQ1ZGJhYTFiNzBiN2E1ZmI2NTE1NzAxNmY0ZmYzZjI0NTM3NGMwOCJ9fX0="}]}}}`,
		"minecraft:warm": `{SkullOwner:{Id:[I;1751171974,-1820507473,-1603456770,1204577294],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGU4NjMzMmJkZDg1NjdlMzk2MDVmMGQxMWJhZTJlNDVlODYwM2E2ZDcxZGEwNjIwOGQ4MWFhM2U3ZTM5NzFjZCJ9fX0="}]}}}`,
		"minecraft:temperate": `{SkullOwner:{Id:[I;-1712625259,-2080355400,-1143664436,-1264327493],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmNhNGE4ZTQ5NDU4MmM2MmFhYTJjOTI0NzRiMTZkNjljZDYzYmFhM2QzZjUwYTRiNjMxZDY1NTljYTBmMzNmNSJ9fX0="}]}}}`
	},
	"minecraft:glow_squid": `{SkullOwner:{Id:[I;2069299867,942427948,-1835496669,1144407642],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGNiMDdkOTA1ODg4Zjg0NzIyNTJmOWNmYTM5YWEzMTdiYWJjYWQzMGFmMDhjZmU3NTFhZGVmYTcxNmIwMjAzNiJ9fX0="}]}}}`,
	"minecraft:goat": `{SkullOwner:{Id:[I;-125220819,-1062649828,-1210361614,842848091],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTY2MjMzNmQ4YWUwOTI0MDdlNThmN2NjODBkMjBmMjBlNzY1MDM1N2E0NTRjZTE2ZTMzMDc2MTlhMDExMDY0OCJ9fX0="}]}}}`,
	"minecraft:hoglin": `{SkullOwner:{Id:[I;-2120826304,-378911692,-1238340839,485405824],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWJiOWJjMGYwMWRiZDc2MmEwOGQ5ZTc3YzA4MDY5ZWQ3Yzk1MzY0YWEzMGNhMTA3MjIwODU2MWI3MzBlOGQ3NSJ9fX0="}]}}}`,
	"minecraft:horse": {
		check: (nbt) => ["white", "creamy", "chestnut", "brown", "black", "gray", "dark_brown"][nbt.Variant & 0xFF],
		prefix: (variant) => variant === "dark_brown" ? "Dark Brown" : variant.charAt(0).toUpperCase() + variant.slice(1),
		"white": `{SkullOwner:{Id:[I;2015916316,1845447098,-1808384121,1754523103],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWY0YmRkNTlkNGY4ZjFkNTc4MmUwZmVlNGJkNjRhZWQxMDA2MjdmMTg4YTkxNDg5YmEzN2VlYWRlZGVkZDgyNyJ9fX0="}]}}}`,
		"chestnut": `{SkullOwner:{Id:[I;508939576,-1315487367,-2139029096,1866223783],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTk5NjM5OWZmZjljYmNmYjdiYTY3N2RkMGMyZDEwNDIyOWQxY2MyMzA3YTZmMDc1YTg4MmRhNDY5NGVmODBhZSJ9fX0="}]}}}`,
		"brown": `{SkullOwner:{Id:[I;349597739,182602294,-1774764075,113095660],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTcxN2Q3MTAyNWY3YTYyYzkwYTMzM2M1MTY2M2ZmZWIzODVhOWEwZDkyYWY2ODA4M2M1YjA0NWMwNTI0YjIzZiJ9fX0="}]}}}`,
		"dark_brown": `{SkullOwner:{Id:[I;-1391760288,-274053570,-2126373471,1131099955],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTU2YjdiYzFhNDgzNmViNDI4ZWE4OTI1ZWNlYjVlMDFkZmJkMzBjN2RlZmY2Yzk0ODI2ODk4MjMyMDNjZmQyZiJ9fX0="}]}}}`,
		"black": `{SkullOwner:{Id:[I;-1500999303,1158565693,-1233130346,-936180955],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2VmYjBiOTg1N2Q3YzhkMjk1ZjZkZjk3YjYwNWY0MGI5ZDA3ZWJlMTI4YTY3ODNkMWZhM2UxYmM2ZTQ0MTE3In19fQ=="}]}}}`,
		"gray": `{SkullOwner:{Id:[I;-725247734,179848459,-1779896801,1837208194],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGYwZDk1NTg4OWIwMzc4ZDQ5MzNjOTU2Mzk4NTY3ZTc3MDEwM2FlOWVmZjBmNzAyZDBkNTNkNTJlN2Y2YTgzYiJ9fX0="}]}}}`,
		"creamy": `{SkullOwner:{Id:[I;-618272927,1541031397,-1724443467,786881355],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTZkYWUwYWRlMGUwZGFmYjZkYmM3Nzg2Y2U0MjQxMjQyYjZiNmRmNTI3YTBmN2FmMGE0MjE4NGM5M2ZkNjQ2YiJ9fX0="}]}}}`
	},
	"minecraft:husk": `{SkullOwner:{Id:[I;-207171088,338838309,-1453827855,-1780856411],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjY5Yjk3MzRkMGU3YmYwNjBmZWRjNmJmN2ZlYzY0ZTFmN2FkNmZjODBiMGZkODQ0MWFkMGM3NTA4Yzg1MGQ3MyJ9fX0="}]}}}`,
	"minecraft:llama": {
		check: (nbt) => ["creamy", "white", "brown", "gray"][nbt.Variant],
		prefix: (variant) => variant.charAt(0).toUpperCase() + variant.slice(1),
		"creamy": `{SkullOwner:{Id:[I;1504955879,-563000534,-1467385729,-654423098],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmFlMjVkZGMyZDI1MzljNTY1ZGZmMmFhNTAwNjAzM2YxNGNjMDYzNzlmZTI4YjA3MzFjN2JkYzY1YmEwZTAxNiJ9fX0="}]}}}`,
		"white": `{SkullOwner:{Id:[I;-1273429067,1219708865,-1383883873,-948421712],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZGU3MDNhYjAzMWVkNjY2MjJmMTI5NTdlZjU5YThiNWM4YTI2OWNlYmQxOGY5MzI2MjQ4YjY4YzNiYmUyMDE2MyJ9fX0="}]}}}`,
		"brown": `{SkullOwner:{Id:[I;1594019581,-4698574,-1524372744,-1161539817],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvN2Y4MzI0NjZkY2M3ZDVlNzcwMmNkZWU0Y2Q1NTVkYmQzOTYzN2QyMGFkZjkzNjdmYjAzY2ZkNjg4OGJhYWFlNyJ9fX0="}]}}}`,
		"gray": `{SkullOwner:{Id:[I;1697534571,310854304,-1890616865,-25002806],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNmQyZmZjZTlhMTc0ZmUxYzA4NGUyZDgyMDUyMTgyZDk0Zjk1ZWQ0MzZiNzVmZjdlYTdhNGU5NGQ5NGM3MmQ4YSJ9fX0="}]}}}`
	},
	"minecraft:mule": `{SkullOwner:{Id:[I;534109024,849300941,-1634894518,-597098711],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTA0ODZhNzQyZTdkZGEwYmFlNjFjZTJmNTVmYTEzNTI3ZjFjM2IzMzRjNTdjMDM0YmI0Y2YxMzJmYjVmNWYifX19"}]}}}`,
	"minecraft:panda": {
		check: (nbt) => nbt.MainGene,
		prefix: (gene) => gene.charAt(0).toUpperCase() + gene.slice(1),
		"normal": `{SkullOwner:{Id:[I;1648193673,1096304930,-1387458717,923627530],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmE2ZTNhZDgyM2Y5NmQ0YTgwYTE0NTU2ZDhjOWM3NjMyMTYzYmJkMmE4NzZjMDExOGI0NTg5MjVkODdhNTUxMyJ9fX0="}]}}}`,
		"brown": `{SkullOwner:{Id:[I;-2102769737,-837531619,-1211653664,1137661308],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjRmN2M3M2ZkYTZhMzRjZjhiZTRjNzkwN2RkMGY1ZjA4NjVkZDc3ZmQ4ODJmYzYzMzU2MzY0OWM1NzUxN2NhZSJ9fX0="}]}}}`,
		"worried": `{SkullOwner:{Id:[I;-1645630299,-1047245358,-1833569590,-1600223514],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjI2NjY3MmU0YmE1NGM1YzBiZTU5ZTA0NjFhNmUzMmVhMGE3Y2YxMTVkNzExODY3ZDI5MjJlZTljYTUyMzY5MCJ9fX0="}]}}}`,
		"playful": `{SkullOwner:{Id:[I;1896017456,-1233435194,-1435507672,-677697807],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWZjMTUyNzI0NmZkYTNlODMxMTI1MzQ0MTRiZGJjYzNjMTBmM2JhNWNmMDhlNDdhZjQ4YTE4ZTc2ZWUxNDhmZCJ9fX0="}]}}}`,
		"lazy": `{SkullOwner:{Id:[I;-215865452,-937996816,-1512558577,-1679126400],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTYyYTAyNGU4NzFiZmIyZWI5OTVkYWQyMWU5ZTcwNDg5MDQzZDNjYmM3M2Q3ZmE1NTIwYWViNzY1OTkzMzQ3In19fQ=="}]}}}`,
		"weak": `{SkullOwner:{Id:[I;-921749140,1022708405,-1625584124,-310730077],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDY3MjE5YTQ2ZDM5NTdlMzI5MmI4MWQyZTI4Zjg2YzYzNTAxZWNiNjY3M2FjZTMyNjAzNWI1MjI5YmQ4ZGI0YSJ9fX0="}]}}}`,
		"aggressive": `{SkullOwner:{Id:[I;-1311468789,-171489966,-1882930538,479594878],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTg4MGUyMzY0OTRlNzEzNWRiOGVjNDVmNjRiYTkyNDljYWRiOTRhNWMxYTdhNTE1N2YzZTAyYjAxYmZkYjBmNiJ9fX0="}]}}}`
	},
	"minecraft:parrot": {
		check: (nbt) => ["red", "blue", "green", "cyan", "gray"][nbt.Variant],
		prefix: (variant) => variant.charAt(0).toUpperCase() + variant.slice(1),
		"red": `{SkullOwner:{Id:[I;-1296310145,338054733,-2042181906,-371061496],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWQxYTE2OGJjNzJjYjMxNGY3Yzg2ZmVlZjlkOWJjNzYxMjM2NTI0NGNlNjdmMGExMDRmY2UwNDIwMzQzMGMxZCJ9fX0="}]}}}`,
		"blue": `{SkullOwner:{Id:[I;972286240,1450332040,-1723774681,3214066],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjBlMDNiMTBjMTVlZTU2MDE0MjM4NjdkZmI4YmNiY2JjOTE5Y2E5NmMwZWVhNjMwNzNlYzhlNzk1ZWFiZDA1ZiJ9fX0="}]}}}`,
		"green": `{SkullOwner:{Id:[I;494666219,329140497,-1233730257,32205190],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZjOWEzYjlkNTg3OWMyMTUwOTg0ZGJmZTU4OGNjMmU2MWZiMWRlMWU2MGZkMmE0NjlmNjlkZDRiNmY2YTk5MyJ9fX0="}]}}}`,
		"cyan": `{SkullOwner:{Id:[I;1435037557,1914717286,-1711661334,1259399168],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmM2NDcxZjIzNTQ3YjJkYmRmNjAzNDdlYTEyOGY4ZWIyYmFhNmE3OWIwNDAxNzI0ZjIzYmQ0ZTI1NjRhMmI2MSJ9fX0="}]}}}`,
		"gray": `{SkullOwner:{Id:[I;-1989585566,-378125309,-1958902943,-1670221508],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTNjMzQ3MjJhYzY0NDk2YzliODRkMGM1NDAxOWRhYWU2MTg1ZDYwOTQ5OTAxMzNhZDY4MTBlZWEzZDI0MDY3YSJ9fX0="}]}}}`
	},
	"minecraft:phantom": `{SkullOwner:{Id:[I;1778552214,-1024113072,-1607075307,-910036991],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjRhZDYzYjY5N2E0YzQ3OTBkMDBjNDM1NDYwYmFmNDkxOTE2NTdlNjFiZWU2MTFmNzU4OGRiY2RhNzE5OGJiZCJ9fX0="}]}}}`,
	"minecraft:piglin_brute": `{SkullOwner:{Id:[I;-1495583819,509627582,-1550874603,2046378806],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2UzMDBlOTAyNzM0OWM0OTA3NDk3NDM4YmFjMjllM2E0Yzg3YTg0OGM1MGIzNGMyMTI0MjcyN2I1N2Y0ZTFjZiJ9fX0="}]}}}`,
	"minecraft:pillager": `{SkullOwner:{Id:[I;-81659728,-65647709,-1396215731,-1911514716],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMThlNTc4NDE2MDdmNDQ5ZTc2YjdjODIwZmNiZDE5MTNlYzFiODBjNGFjODE3Mjg4NzRkYjIzMGY1ZGYyYjNiIn19fQ=="}]}}}`,
	"minecraft:polar_bear": `{SkullOwner:{Id:[I;2129559342,1919042708,-1745503587,778571610],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2QzY2Q4NTQ4ZTdkY2ViNWMyMzk0ZDFiMDBkYTJjNjFmZmMwZGRlNDYyMjliMTA1MDllYjI3YTBkY2IyM2JmYiJ9fX0="}]}}}`,
	"minecraft:rabbit": {
		check: (nbt) => ["brown", "white", "black", "white_splotched", "gold", "salt"][nbt.RabbitType === 99 ? 1 : nbt.RabbitType],
		prefix: (variant) => variant === "white_splotched" ? "Black & White" : variant.charAt(0).toUpperCase() + variant.slice(1),
		"brown": `{SkullOwner:{Id:[I;-786196433,1495813401,-1308545490,-441862633],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzFkYjM4ZWYzYzFhMWQ1OWY3NzlhMGNkOWY5ZTYxNmRlMGNjOWFjYzc3MzRiOGZhY2MzNmZjNGVhNDBkMDIzNSJ9fX0="}]}}}`,
		"white": `{SkullOwner:{Id:[I;388579053,933251194,-1575850090,-1207120602],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTBkY2RkYzIzNjk3MmVkY2Q0OGU4MjViNmIwMDU0YjdiNmUxYTc4MWU2ZjEyYWUwNGMxNGEwNzgyN2NhOGRjYyJ9fX0="}]}}}`,
		"black": `{SkullOwner:{Id:[I;-210878417,-1993784983,-1131862712,711531413],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTlhNjc1ZWRiM2NiYTBmMzQzNmFlOTQ3M2NmMDM1OTJiN2E0OWQzODgxMzU3OTA4NGQ2MzdlNzY1OTk5OWI4ZSJ9fX0="}]}}}`,
		"white_splotched": `{SkullOwner:{Id:[I;-1150658095,-1543811353,-1615176207,-113842898],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzJmMzllMGE2MDMzODZjYTFlZTM2MjM2ZTBiNDkwYTE1NDdlNmUyYTg5OTExNjc0NTA5MDM3ZmI2ZjcxMTgxMCJ9fX0="}]}}}`,
		"gold": `{SkullOwner:{Id:[I;-1837062534,1395934471,-1386753792,-752365147],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMmE2MzYxZmVhMjRiMTExZWQ3OGMxZmVmYzI5NTIxMmU4YTU5YjBjODhiNjU2MDYyNTI3YjE3YTJkNzQ4OWM4MSJ9fX0="}]}}}`,
		"salt": `{SkullOwner:{Id:[I;1755354286,-989903234,-1557305868,1052548919],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2M0MzQ5ZmU5OTAyZGQ3NmMxMzYxZjhkNmExZjc5YmZmNmY0MzNmM2I3YjE4YTQ3MDU4ZjBhYTE2YjkwNTNmIn19fQ=="}]}}}`
	},
	"minecraft:ravager": `{SkullOwner:{Id:[I;520102013,1535003450,-1604796681,-835899773],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWM3M2UxNmZhMjkyNjg5OWNmMTg0MzQzNjBlMjE0NGY4NGVmMWViOTgxZjk5NjE0ODkxMjE0OGRkODdlMGIyYSJ9fX0="}]}}}`,
	"minecraft:shulker": `{SkullOwner:{Id:[I;-1778823362,-434352489,-1592043985,1155190429],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTM3YTI5NGY2YjdiNGJhNDM3ZTVjYjM1ZmIyMGY0Njc5MmU3YWMwYTQ5MGE2NjEzMmE1NTcxMjRlYzVmOTk3YSJ9fX0="}]}}}`,
	"minecraft:skeleton_horse": `{SkullOwner:{Id:[I;-1128471105,-2033955230,-1614476087,233393005],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDdlZmZjZTM1MTMyYzg2ZmY3MmJjYWU3N2RmYmIxZDIyNTg3ZTk0ZGYzY2JjMjU3MGVkMTdjZjg5NzNhIn19fQ=="}]}}}`,
	"minecraft:sniffer": `{SkullOwner:{Id:[I;-1126623494,744768057,-1978495903,-1031262652],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmU1YTgzNDFjNDc4YTEzNDMwMjk4MWU2YTc3NThlYTRlY2ZkOGQ2MmEwZGY0MDY3ODk3ZTc1NTAyZjliMjVkZSJ9fX0="}]}}}`,
	"minecraft:stray": `{SkullOwner:{Id:[I;-1964313252,-84653046,-1398821127,-1569551588],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWUzOTFjNmU1MzVmN2FhNWEyYjZlZTZkMTM3ZjU5ZjJkN2M2MGRlZjg4ODUzYmE2MTFjZWIyZDE2YTdlN2M3MyJ9fX0="}]}}}`,
	"minecraft:strider": `{SkullOwner:{Id:[I;1540698924,-955495724,-1441155172,-1921625949],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTI1ODUxYTg2ZWUxYzU0Yzk0ZmM1YmVkMDE3ODIzZGZiM2JhMDhlZGRiY2FiMmE5MTRlZjQ1YjU5NmMxNjAzIn19fQ=="}]}}}`,
	"minecraft:trader_llama": {
		check: (nbt) => ["creamy", "white", "brown", "gray"][nbt.Variant],
		prefix: (variant) => variant.charAt(0).toUpperCase() + variant.slice(1),
		"creamy": `{SkullOwner:{Id:[I;-1208012849,-228898058,-1798521208,1995825462],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNTYzMDdmNDJmYzg4ZWJjMjExZTA0ZWEyYmI0ZDI0N2I3NDI4YjcxMWRmOWE0ZTBjNmQxYjkyMTU4OWU0NDNhMSJ9fX0="}]}}}`,
		"white": `{SkullOwner:{Id:[I;987919522,1934050171,-1446023786,-2114938911],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTVhZDZiNjljYzZiNDc2OWQzNTE2YTBjZTk4Yjk5YjJhNWQ0MDZmZWE0OTEyZGVjNTcwZWE0YTRmMmJjYzBmZiJ9fX0="}]}}}`,
		"brown": `{SkullOwner:{Id:[I;-1002363691,1323910903,-2066858296,-1781172850],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWE0ZWVkODU2OTdjNzhmNDYyYzRlYjU2NTNiMDViNzY1NzZjMTE3OGY3MDRmM2M1Njc2ZjUwNWQ4ZjM5ODNiNCJ9fX0="}]}}}`,
		"gray": `{SkullOwner:{Id:[I;-115618488,2116568856,-1549665512,1624898953],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMjBmZGZhNjBjNjI0ZmI2NjdjODMxM2IyZmIxZGFiNDBlMGFkMmU2ZTQ2OWI1NjdiZjU5NmFkMjYzOTIzMTljNSJ9fX0="}]}}}`
	},
	"minecraft:turtle": `{SkullOwner:{Id:[I;-252438200,1149650149,-2009212775,1724878958],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNzYxY2QzZTVmN2E5YmI1OGEwZWQyNGRmOTRlMjc1MTNlYTYxYzdhNDFmMzNlMDE4MGFkOWM4NWY1MzI3ZjdjNSJ9fX0="}]}}}`,
	"minecraft:vex": `{SkullOwner:{Id:[I;-952707620,-1627502996,-1944569961,606909303],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjY2MzEzNGQ3MzA2YmI2MDQxNzVkMjU3NWQ2ODY3MTRiMDQ0MTJmZTUwMTE0MzYxMWZjZjNjYzE5YmQ3MGFiZSJ9fX0="}]}}}`,
	"minecraft:vindicator": `{SkullOwner:{Id:[I;1053432760,-1750514720,-2123590235,-47542450],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGY2ZmI4OWQxYzYzMWJkN2U3OWZlMTg1YmExYTY3MDU0MjVmNWMzMWE1ZmY2MjY1MjFlMzk1ZDRhNmY3ZTIifX19"}]}}}`,
	"minecraft:wandering_trader": `{SkullOwner:{Id:[I;-516577917,-101826017,-1329174962,905446948],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzAzZmRkMjU3NjNiM2Q0NzVlMDlmOGJmNWE0MmU4NjgzZTQ4YWI3MzIzYTNjYzU0MmJiOGQ5OWFlNGI3MDNiOSJ9fX0="}]}}}`,
	"minecraft:zoglin": `{SkullOwner:{Id:[I;-518439016,1184517841,-1335491406,-1199358956],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvM2M4YzdjNWQwNTU2Y2Q2NjI5NzE2ZTM5MTg4YjIxZTdjMDQ3NzQ3OWYyNDI1ODdiZjE5ZTBiYzc2YjMyMjU1MSJ9fX0="}]}}}`,
	"minecraft:zombie_horse": `{SkullOwner:{Id:[I;-1323925695,635060790,-1497653171,-1350172134],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTcxY2U0NjljYmE0NDI2YzgxMWY2OWJlNWQ5NThhMDliZmI5YjFiMmJiNjQ5ZDM1NzdhMGMyMTYxYWQyZjUyNCJ9fX0="}]}}}`,
	"minecraft:zombie_villager": `{SkullOwner:{Id:[I;-684646928,-1780986962,-2040836982,-735132460],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzQ1YzExZTAzMjcwMzU2NDljYTA2MDBlZjkzODkwMGUyNWZkMWUzODAxNzQyMmJjOTc0MGU0Y2RhMmNiYTg5MiJ9fX0="}]}}}`,
	"trials:bogged": `{SkullOwner:{Id:[I;1565737524,-1843770786,-1232181453,433123778],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTNiOTAwM2JhMmQwNTU2MmM3NTExOWI4YTYyMTg1YzY3MTMwZTkyODJmN2FjYmFjNGJjMjgyNGMyMWViOTVkOSJ9fX0="}]}}}`,
	"trials:breeze": `{SkullOwner:{Id:[I;-1448533537,1470778645,-1193497444,343109422],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTI3NTcyOGFmN2U2YTI5Yzg4MTI1YjY3NWEzOWQ4OGFlOTkxOWJiNjFmZGMyMDAzMzdmZWQ2YWIwYzQ5ZDY1YyJ9fX0="}]}}}`,
	"the_bumblezone:bee_queen": `{SkullOwner:{Id:[I;-1574452387,-1689826025,-1402958122,-762227637],Properties:{textures:[{Value:"eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTIyOTg2MTg4ZDAzNGRhYzA4ZmQxOTdjYjYwYzdlNmNlYmZjODQ0ZjJmMmYxN2I0ODZhNjRjMzk2MTdlMTk3MSJ9fX0="}]}}}`
}

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Entity drops handling
EntityEvents.drops(event => {
	// Load constants for easy access
	const player = event.getSource().getPlayer();
	const entity = event.getEntity();
	
	// Runs if the type exists in the head drops
	if (allowHeadsToDrop && headsToDrop[entity.getType()] && player != null)
	{
		// Load item being held
		let heldItem = player.getMainHandItem();
		let beheading = heldItem.getEnchantmentLevel("cyclic:beheading");
		
		// If beheading isn't active return
		if (beheading <= 0)
			return;
		
		// Get Skull Info
		let dropInfo = headsToDrop[entity.getType()];
		let nbt = !(dropInfo instanceof Object) ? dropInfo : dropInfo[dropInfo.check(entity.getNbt())];
		
		// If the NBT check is undefined end the handling here
		if (nbt === undefined)
		{
			console.log("Failed to process NBT for head drop: " + entity.getNbt());
			return;
		}
		
		let prefix = dropInfo.prefix ? dropInfo.prefix(dropInfo.check(entity.getNbt())) : "";
		let headName = (prefix.length > 0 ? prefix + " " : "") + entity.getName().getString().replace("Unemployed", "Villager") + "'s Head";

		// Drop the skull
		event.addDrop(Item.of("minecraft:player_head", 1, `{Mob:"${entity.getType()}",` + nbt.slice(1)).withName(Text.of(headName)), beheadingFormula(beheading));
	}
});